/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.AbstractTextElement;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class Tooltip
extends AbstractTextElement {
    public static final int DEFAULT_MAX_WIDTH = 208;
    public static final int DEFAULT_MAX_HEIGHT = 1000000;
    private static final int CURSOR_BOX_SIZE = 12;
    private static final int Z_OFFSET = 200;
    private static final int BACKGROUND_COLOR = -267386864;
    private static final int BORDER_COLOR_A = 0x505000FF;
    private static final int BORDER_COLOR_B = 1344798847;
    public static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    protected boolean autoWidth = true;
    protected boolean autoHeight = true;
    protected int maxWidth = 208;
    protected int maxHeight = 1000000;

    @Deprecated
    public Tooltip() {
        super(Alignment.TOP_LEFT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, true, true);
        this.init();
    }

    public Tooltip(PaneParams params) {
        super(params, Alignment.TOP_LEFT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, true, true);
        this.autoWidth = this.width == 0;
        this.autoHeight = this.height == 0;
        this.init();
    }

    protected void init() {
        this.textLinespace = 1;
        this.textOffsetX = 4;
        this.textOffsetY = 4;
        this.hide();
        this.recalcTextRendering();
    }

    @Override
    protected void recalcTextRendering() {
        if (this.textScale <= 0.0 || this.isTextEmpty()) {
            this.preparedText = Collections.emptyList();
            return;
        }
        if (this.autoWidth) {
            this.textWidth = Math.min(this.text.stream().mapToInt(arg_0 -> ((FontRenderer)this.mc.field_71466_p).func_238414_a_(arg_0)).max().orElse(Integer.MAX_VALUE), this.maxWidth - 8);
        }
        if (this.autoHeight) {
            this.textHeight = this.maxHeight - 8;
        }
        super.recalcTextRendering();
        if (this.autoWidth) {
            this.width = this.renderedTextWidth + 8;
        }
        if (this.autoHeight) {
            this.height = this.renderedTextHeight + 8;
        }
    }

    @Override
    public void setSize(int w, int h) {
        this.autoWidth = w == 0;
        this.autoHeight = h == 0;
        super.setSize(w, h);
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
    }

    @Override
    public void drawSelfLast(MatrixStack ms, double mx, double my) {
        if (!this.preparedText.isEmpty() && this.enabled) {
            this.x = (int)mx + 12 - 4;
            this.y = (int)my - 12 - 4;
            if (this.x + this.width + 3 > this.window.getScreen().field_230708_k_) {
                this.x = this.window.getScreen().field_230708_k_ - this.width - 4;
            }
            if (this.y + this.height + 3 > this.window.getScreen().field_230709_l_) {
                this.y = this.window.getScreen().field_230709_l_ - this.height - 4;
            }
            ms.func_227860_a_();
            ms.func_227861_a_((double)this.x, (double)this.y, 200.0);
            BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
            Matrix4f matrix4f = ms.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            Tooltip.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)1, (int)0, (int)(this.width - 1), (int)this.height, (int)0, (int)-267386864, (int)-267386864);
            Tooltip.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)0, (int)1, (int)1, (int)(this.height - 1), (int)0, (int)-267386864, (int)-267386864);
            Tooltip.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(this.width - 1), (int)1, (int)this.width, (int)(this.height - 1), (int)0, (int)-267386864, (int)-267386864);
            Tooltip.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)1, (int)2, (int)2, (int)(this.height - 2), (int)0, (int)0x505000FF, (int)1344798847);
            Tooltip.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(this.width - 2), (int)2, (int)(this.width - 1), (int)(this.height - 2), (int)0, (int)0x505000FF, (int)1344798847);
            Tooltip.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)1, (int)1, (int)(this.width - 1), (int)2, (int)0, (int)0x505000FF, (int)0x505000FF);
            Tooltip.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)1, (int)(this.height - 2), (int)(this.width - 1), (int)(this.height - 1), (int)0, (int)1344798847, (int)1344798847);
            RenderSystem.enableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
            ms.func_227861_a_((double)(-this.x), (double)(-this.y), 0.0);
            super.drawSelf(ms, mx, my);
            ms.func_227865_b_();
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public boolean isPointInPane(double mx, double my) {
        return false;
    }
}

